/*
 * Copyright 2008 Richard Mitton.
 *
 * This file is part of Jam - see jam.c for Copyright information.
 */

/*
 * mkmodlist.c - constructs support code to reference module files.
 *
 * Usage: mkmodlist modlist.c modules ...
 *
 */

# include <stdio.h>
# include <string.h>

/* dir\foo.jam --> foo */
const char *modname( const char *filename )
{
	static char buf[ 1024 ];
	char *p;

	p = strrchr( filename, '\\' );
	if ( p )
		filename = p+1;
	p = strrchr( filename, '/' );
	if ( p )
		filename = p+1;

	strcpy( buf, filename );
	p = strrchr( buf, '.' );
	if ( p )
		*p = 0;
	return buf;
}

main( int argc, char **argv, char **envp )
{
	FILE *fout;
	int n;

	if( argc < 3 )
	{
	    fprintf( stderr, "usage: %s modlist.c modules ...\n", argv[0] );
	    return -1;
	}

	if( !( fout = fopen( argv[1], "w" ) ) )
	{
	    perror( argv[1] );
	    return -1;
	}

	/* Now process the files */

	argc -= 2, argv += 2;

	fprintf( fout, "/* Generated by mkmodlist */\n\n" );
	for (n=0;n<argc;n++)
		fprintf( fout, "extern const char *txt_%s;\n", modname( argv[n] ) );

    fprintf( fout, "\nconst char *modnames[] = {\n" );
	for (n=0;n<argc;n++)
			fprintf( fout, "\"%s\",\n", modname( argv[n] )  );
    fprintf( fout, "0 };\n" );
	    
    fprintf( fout, "\nconst char **moddata[] = {\n" );
	for (n=0;n<argc;n++)
			fprintf( fout, "&txt_%s,\n", modname( argv[n] )  );
    fprintf( fout, "0 };\n" );
	    
	fclose( fout );

	return 0;
}
