/*
 * Copyright 1993, 1995 Christopher Seiwald.
 *
 * This file is part of Jam - see jam.c for Copyright information.
 */

/*
 * command.c - maintain lists of commands
 *
 * 01/20/00 (seiwald) - Upgraded from K&R to ANSI C
 * 09/08/00 (seiwald) - bulletproof PIECEMEAL size computation
 */

# include "jam.h"

# include "lists.h"
# include "parse.h"
# include "variable.h"
# include "rules.h"

# include "command.h"

/*
 * cmd_new() - return a new CMD or 0 if too many args
 */

CMD *
cmd_new(
	RULE	*rule,
	LIST	*targets,
	LIST	*sources,
	LIST	*shell,
	int	maxline )
{
	int     len;
#ifdef OPT_DYNAMIC_COMMAND_SIZE_EXT
	int	size = MAXLINE;
	int     keepGrowing = 1;
#endif

	CMD *cmd = (CMD *)malloc( sizeof( CMD ) );
#ifdef OPT_DYNAMIC_COMMAND_SIZE_EXT
	cmd->buf = (char *)malloc( sizeof( char ) * size );
#endif

	cmd->rule = rule;
	cmd->shell = shell;
	cmd->next = 0;

	lol_init( &cmd->args );
	lol_add( &cmd->args, targets );
	lol_add( &cmd->args, sources );

#ifndef OPT_DYNAMIC_COMMAND_SIZE_EXT
	/* Bail if the result won't fit in maxline */
	/* We don't free targets/sources/shell if bailing. */

	len = var_string( rule->actions, cmd->buf, maxline, &cmd->args );
#else
        /* Most commands fit in the buffer - so don't worry too much about
         * sometimes computing the string twice. */
	do {
	    len = var_string( rule->actions, cmd->buf, size, &cmd->args );

	    /* If this is a piecemeal rule, we don't grow */
	    if (len < 0 && ((rule->flags & RULE_PIECEMEAL) == 0)) {
		free (cmd->buf);
		size *= 5;
		cmd->buf = (char *)malloc( sizeof( char ) * size );
	    }
	    else
		keepGrowing = 0;
	} while (keepGrowing);
#endif
	
	if( len < 0 )
	{
	    cmd_free( cmd );
	    return 0;
	}

	return cmd;
}

/*
 * cmd_free() - free a CMD
 */

void
cmd_free( CMD *cmd )
{
	lol_free( &cmd->args );
	list_free( cmd->shell );
#ifdef OPT_DYNAMIC_COMMAND_SIZE_EXT
	free( (char *)cmd->buf );
#endif
	free( (char *)cmd );
}
