/*
 * Decompiled with CFR 0.152.
 */
package org.waxeye.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.waxeye.ast.AST;
import org.waxeye.ast.Char;
import org.waxeye.ast.Empty;
import org.waxeye.ast.IAST;
import org.waxeye.ast.Position;
import org.waxeye.input.IParserInput;
import org.waxeye.parser.AutomatonTransition;
import org.waxeye.parser.CacheItem;
import org.waxeye.parser.CacheKey;
import org.waxeye.parser.CharTransition;
import org.waxeye.parser.Edge;
import org.waxeye.parser.FA;
import org.waxeye.parser.IParser;
import org.waxeye.parser.ITransitionVisitor;
import org.waxeye.parser.ParseError;
import org.waxeye.parser.ParseResult;
import org.waxeye.parser.State;
import org.waxeye.parser.WildCardTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parser<E extends Enum<?>>
implements IParser<E> {
    private final IAST<E> empty;
    private final E charType;
    private final E posType;
    private final E negType;
    private final List<FA<E>> automata;
    private final boolean eofCheck;
    private final int start;

    public Parser(List<FA<E>> automata, boolean eofCheck, int start, E emptyType, E charType, E posType, E negType) {
        this.automata = automata;
        this.eofCheck = eofCheck;
        this.start = start;
        this.empty = new Empty<E>(emptyType);
        this.charType = charType;
        this.posType = posType;
        this.negType = negType;
    }

    @Override
    public final ParseResult<E> parse(IParserInput input) {
        return new InnerParser(input).parse();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InnerParser
    implements ITransitionVisitor<E> {
        private final IParserInput input;
        private final Stack<FA<E>> faStack;
        private final HashMap<CacheKey, CacheItem<E>> cache;
        private int line;
        private int column;
        private boolean lastCR;
        private int errorPos;
        private int errorLine;
        private int errorCol;
        private String errorNT;

        InnerParser(IParserInput input) {
            this.input = input;
            this.faStack = new Stack();
            this.cache = new HashMap();
            this.line = 1;
            this.column = 0;
            this.lastCR = false;
            this.errorPos = 0;
            this.errorLine = 1;
            this.errorCol = 0;
            this.errorNT = ((Enum)((FA)Parser.this.automata.get(Parser.this.start)).getType()).name();
        }

        ParseResult<E> parse() {
            IAST ast = this.matchAutomaton(Parser.this.start);
            ParseError error = null;
            if (ast == null) {
                error = new ParseError(this.errorPos, this.errorLine, this.errorCol, this.errorNT);
            } else if (Parser.this.eofCheck && this.input.peek() != -1) {
                error = new ParseError(this.errorPos, this.errorLine, this.errorCol, this.errorNT);
                ast = null;
            }
            return new ParseResult(ast, error);
        }

        private void restorePos(int pos, int line, int col, boolean cr) {
            this.input.setPosition(pos);
            this.line = line;
            this.column = col;
            this.lastCR = cr;
        }

        private IAST<E> matchAutomaton(int index) {
            IAST value;
            int startPos = this.input.getPosition();
            CacheKey key = new CacheKey(index, startPos);
            CacheItem cachedItem = this.cache.get(key);
            if (cachedItem != null) {
                this.restorePos(cachedItem.getPosition(), cachedItem.getLine(), cachedItem.getColumn(), cachedItem.getLastCR());
                return cachedItem.getResult();
            }
            int startLine = this.line;
            int startCol = this.column;
            boolean startCR = this.lastCR;
            FA automaton = (FA)Parser.this.automata.get(index);
            Object type = automaton.getType();
            int mode = automaton.getMode();
            this.faStack.push(automaton);
            List res = this.matchState(0);
            this.faStack.pop();
            if (((Enum)type).equals(Parser.this.posType)) {
                this.restorePos(startPos, startLine, startCol, startCR);
                value = res == null ? null : Parser.this.empty;
            } else if (((Enum)type).equals(Parser.this.negType)) {
                this.restorePos(startPos, startLine, startCol, startCR);
                if (res == null) {
                    value = Parser.this.empty;
                } else {
                    this.updateError();
                    value = null;
                }
            } else if (res == null) {
                this.updateError();
                value = null;
            } else {
                block0 : switch (mode) {
                    case 1: {
                        value = Parser.this.empty;
                        break;
                    }
                    case 2: {
                        switch (res.size()) {
                            case 0: {
                                value = Parser.this.empty;
                                break block0;
                            }
                            case 1: {
                                value = res.get(0);
                                break block0;
                            }
                        }
                        value = new AST(type, res, new Position(startPos, this.input.getPosition()));
                        break;
                    }
                    default: {
                        value = new AST(type, res, new Position(startPos, this.input.getPosition()));
                    }
                }
            }
            this.cache.put(key, new CacheItem(value, this.input.getPosition(), this.line, this.column, this.lastCR));
            return value;
        }

        private List<IAST<E>> matchState(int index) {
            State state = this.faStack.peek().getStates().get(index);
            List res = this.matchEdges(state.getEdges(), 0);
            if (res == null) {
                if (state.isMatch()) {
                    return new ArrayList();
                }
                return null;
            }
            return res;
        }

        private List<IAST<E>> matchEdges(List<Edge<E>> edges, int index) {
            if (index < edges.size()) {
                List res = this.matchEdge(edges.get(index));
                if (res == null) {
                    return this.matchEdges(edges, index + 1);
                }
                return res;
            }
            return null;
        }

        private List<IAST<E>> matchEdge(Edge<E> edge) {
            int startPos = this.input.getPosition();
            int startLine = this.line;
            int startCol = this.column;
            boolean startCR = this.lastCR;
            IAST res = edge.getTrans().acceptVisitor(this);
            if (res == null) {
                return null;
            }
            List transRes = this.matchState(edge.getState());
            if (transRes == null) {
                this.restorePos(startPos, startLine, startCol, startCR);
                return null;
            }
            if (edge.isVoided() || res.equals(Parser.this.empty)) {
                return transRes;
            }
            transRes.add(0, res);
            return transRes;
        }

        private void updateLineCol(char ch) {
            if (ch == '\r') {
                ++this.line;
                this.column = 0;
                this.lastCR = true;
            } else {
                if (ch == '\n') {
                    if (!this.lastCR) {
                        ++this.line;
                        this.column = 0;
                    }
                } else {
                    ++this.column;
                }
                this.lastCR = false;
            }
        }

        private void updateError() {
            if (this.errorPos < this.input.getPosition()) {
                this.errorPos = this.input.getPosition();
                this.errorLine = this.line;
                this.errorCol = this.column;
                this.errorNT = ((Enum)this.faStack.peek().getType()).name();
            }
        }

        @Override
        public IAST<E> visitAutomatonTransition(AutomatonTransition<E> t) {
            return this.matchAutomaton(t.getIndex());
        }

        @Override
        public IAST<E> visitCharTransition(CharTransition<E> t) {
            char c;
            if (this.input.peek() != -1 && t.withinSet(c = (char)this.input.peek())) {
                this.input.consume();
                this.updateLineCol(c);
                return new Char<Enum>(c, Parser.this.charType);
            }
            this.updateError();
            return null;
        }

        @Override
        public IAST<E> visitWildCardTransition(WildCardTransition<E> t) {
            if (this.input.peek() == -1) {
                this.updateError();
                return null;
            }
            char c = (char)this.input.consume();
            this.updateLineCol(c);
            return new Char<Enum>(c, Parser.this.charType);
        }
    }
}

