/*
 * Decompiled with CFR 0.152.
 */
package org.waxeye.parser;

final class CacheKey {
    private final int expressionIndex;
    private final int inputIndex;
    private final Object context;
    private final int hashCode;

    public CacheKey(int expressionIndex, int inputIndex) {
        this(expressionIndex, inputIndex, null);
    }

    public CacheKey(int expressionIndex, int inputIndex, Object context) {
        this.expressionIndex = expressionIndex;
        this.inputIndex = inputIndex;
        this.context = context;
        this.hashCode = this.makeHashCode();
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (this.inputIndex >= 0);
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            CacheKey m = (CacheKey)object;
            if (this.expressionIndex == m.expressionIndex && this.inputIndex == m.inputIndex && (this.context == null && m.context == null || this.context.equals(m.context))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int makeHashCode() {
        int start = 17;
        int mult = 37;
        int result = 17 + this.expressionIndex;
        result = 37 * result + this.inputIndex;
        if (this.context != null) {
            result = 37 * result + this.context.hashCode();
        }
        return Math.abs(result);
    }
}

