#include <stdio.h>
#include <algorithm>
#define STBI_HEADER_FILE_ONLY
#define STB_IMAGE_WRITE_IMPLEMENTATION
#include "stb_image.c"
#include "stb_image_write.h"

#define SCALE 8

typedef unsigned char BYTE;

struct Pixel { BYTE r, g, b, a; };

int w, h, tw, th;
int prevx, prevy;
Pixel *image;
Pixel *out;
bool *done;

int numPixels = 0, numSteps = 0;

void line(int x0, int y0, int x1, int y1)
{
	x0 = x0*SCALE + SCALE/2;
	y0 = y0*SCALE + SCALE/2;
	x1 = x1*SCALE + SCALE/2;
	y1 = y1*SCALE + SCALE/2;

	if (x0 == x1)
	{
		if (y1 < y0)
			std::swap(y0, y1);
		while(y0 <= y1)
		{
			Pixel *p = &out[y0*w*SCALE+x0];
			p->r = 255; p->g = 0; p->b = 0; p->a = 255;
			y0++;
		}
	} else {
		assert(y0==y1);
		if (x1 < x0)
			std::swap(x0, x1);
		while(x0 <= x1)
		{
			Pixel *p = &out[y0*w*SCALE+x0];
			p->r = 255; p->g = 0; p->b = 0; p->a = 255;
			x0++;
		}
	}
}

bool issolid(int tx, int ty)
{
	if (image[ty*2*w+tx*2+0].a > 0
	 || image[ty*2*w+tx*2+1].a > 0
	 || image[ty*2*w+tx*2+w+0].a > 0
	 || image[ty*2*w+tx*2+w+1].a > 0)
		return true;
	else
		return false;
}


void walk(int x, int y)
{
	int tx = x/2, ty = y/2;
	if (done[ty*tw+tx])
		return;

	if (!issolid(tx, ty))
		return;

	done[ty*tw+tx] = true;

	for (int n=0;n<4;n++)
	{
		// Visit this pixel.
		// Draw a line from prevx/y to x/y
		unsigned id = (x&1) | ((y&1)*2);
		line(prevx, prevy, x, y);
		prevx = x;
		prevy = y;
		numSteps++;

		switch(id) {
		case 0: walk(x,y-1); x++; break;
		case 1: walk(x+1,y); y++; break;
		case 3: walk(x,y+1); x--; break;
		case 2: walk(x-1,y); y--; break;
		}
	}
}

int main()
{
	int comps;

	// Load image and produce scaled output.
	image = (Pixel *)stbi_load("tce_logo.png", &w, &h, &comps, 0);
	tw = w/2;
	th = h/2;
	out = new Pixel[w*h*SCALE*SCALE];
	done = new bool[tw*th];
	memset(done, 0, sizeof(bool)*tw*th);

	// Count solid pixels.
	for (int y=0;y<h;y++)
	{
		for (int x=0;x<w;x++)
		{
			if (image[y*w+x].a > 0)
				numPixels++;
		}
	}

	Pixel *dest = out;
	for (int y=0;y<h*SCALE;y++)
	{
		for (int x=0;x<w*SCALE;x++)
		{
			int ix = x/SCALE, iy = y/SCALE;
			*dest = image[iy*w+ix];
			if (dest->a == 0)
			{
				dest->a = 255;
			}
			dest++;
		}
	}

	// Find a random starting place.
	int sx=0,sy=0;
	for (int y=0;y<th;y++)
	{
		for (int x=0;x<tw;x++)
		{
			if (issolid(x, y))
			{
				sx = x;
				sy = y;
				goto found;
			}
		}
	}
found:

	// Traverse it.
	prevx = sx*2;
	prevy = sy*2;
	walk(prevx, prevy);

	printf("Visited %i pixels in %i steps (%.1f%% optimal)\n", numPixels, numSteps, 100.0f * numPixels / numSteps);

	// Save it.
	stbi_write_png("out.png", w*SCALE, h*SCALE, 4, out, w*SCALE*sizeof(Pixel));
	return 0;
}
