#include "ludum.h"

Actor *player = NULL;

Result scriptDefaultLogic2()
{
	if ( !command.a.actor && !command.a.got )
	{
		walkto( player, command.x, command.y );
		return DONE;
	}

	if ( command.verb == VERB_PICKUP )
	{
		Actor *actor = command.a.actor;

		if ( actor )
		{
			if ( !standBy( player, actor ) )
				return NOTDONE;
			
			if ( actor->flags & FLAG_MAN )
				say( player, "I don't think he'd like that." );
			else if ( actor->flags & FLAG_FIXED )
				say( player, "It doesn't seem to move." );
			else
				say( player, "I'm not sure I really need that." );
			return DONE;
		}

		if ( command.a.got )
		{
			say( player, "I already have it." );
			return DONE;
		}
	} else if ( command.verb == VERB_GIVE ) {
		if ( !command.hasSecond )
		{
			command.needSecond = true;
			return NOTDONE;
		}

		if ( !command.a.got )
		{
			say( player, "I don't have it." );
			return DONE;
		}

		if ( command.b.actor == NULL && command.b.got == NULL )
			return DONE;

		if ( command.a == command.b )
			say( player, "I don't think so." );
		else if ( getFlags( command.b ) & FLAG_MAN )
			say( player, "I don't think he wants it." );
		else
			say( player, "It just doesn't seem interested in it." );

		return DONE;
	} else if ( command.verb == VERB_TALKTO ) {
		if ( command.a.actor )
		{
			if ( command.a.actor->flags & FLAG_MAN )
				say( player, "He doesn't seem to be listening." );
			else
				say( player, "The conversation would be a little one-sided." );
		} else if ( command.a.got ) {
			say( player, "Pockets are not for talking into." );
		}
		return DONE;
	} else if ( command.verb == VERB_LOOKAT ) {
		static uint n = 0;
		switch( ( n++ ) % 3 )
		{
		case 0: say( player, "I don't see anything special about it." ); break;
		case 1: say( player, "Nothing remarkable there." ); break;
		case 2: say( player, "Not much to look at." ); break;
		}
		return DONE;
	} else if ( command.verb == VERB_USE ) {
		say( player, "I'm not sure I can." );
		return DONE;
	} else {
		if ( command.a.actor )
		{
			if ( standBy( player, command.a.actor ) )
				return DONE;
			else
				return NOTDONE;
		} else {
			return DONE;
		}
	}

	return UNKNOWN;
}

Result scriptDefaultLogic()
{
	Result r = scriptDefaultLogic2();
	if ( r == UNKNOWN )
	{
		say( player, "You just did something so weird I\ndidn't even have code to handle it." );
		r = DONE;
	}

	return r;
}

void scriptStartup()
{
	scriptSetScene( SCENE_TITLE );
}

void scriptPrepareScene( uint scene )
{
	switch( scene )
	{
	case SCENE_SHORES: scriptNew( sceneShores, NULL, true ); break;
	case SCENE_CAVERN: scriptNew( sceneCavern, NULL, true ); break;
	case SCENE_FIELD: scriptNew( sceneField, NULL, true ); break;
	case SCENE_BEYOND: scriptNew( sceneBeyond, NULL, true ); break;
	case SCENE_END: scriptNew( sceneEnd, NULL, true ); break;
	case SCENE_TITLE: scriptNew( sceneTitle, NULL, true ); break;
	default: __debugbreak();
	}
}
