#include "ludum.h"

static Actor *ragnar;
static Actor *soul;
static Actor *cavern;
static Actor *sign;
static Actor *door;
static Actor *charon;
static Actor *islands;

static bool firstTime = true;
static uint numTimesCrossed = 0;
static bool convinced = false;
static bool takenCoin = false;

void talkSoul()
{
	lookat( soul, player );
	conversation();

start: options();
	if ( option( "Hi there." ) )
	{
		saywait( soul, "Hello stranger." );
		goto start;
	}
	static bool who = false;
	static bool howlong = false;

	if ( optiononce( ID, "Who are you?" ) )
	{
		saywait( soul, "Who's asking?" );
whoami: options();
		if ( option( "My name is Ragnar." ) )
		{
			saywait( soul, "Well that's a silly name." );
			saywait( player, "It's a Swedish name. That's where I'm from." );
			saywait( soul, "Never heard of it." );
			who = true;
			goto start;
		}
		if ( option( "I'm Guybrush Threepwood, a mighty pirate!" ) )
		{
			saywait( soul, "That can't be right. No-one's called Guybrush." );
			goto whoami;
		}
		goto whoami;
	}
	if ( who && optiononce( ID, "What is this place?" ) )
	{
		saywait( soul, "You don't know where you are?" );
		saywait( player, "Um, no. I just kind of woke up here." );
		wait( 60 );
		saywait( soul, "<sigh>" );
		wait( 60 );
		saywait( soul, "Figures, they never bother to tell anyone." );
		saywait( soul, "Always leave it for me to do the explaining." );
		wait( 120 );
		saywait( soul, "You're dead, son." );
		saywait( player, "Dead!? I can't be dead!" );
		saywait( player, "I have a wife! A family!" );
		saywait( soul, "I guess you should have thought of that beforehand." );
		saywait( soul, "Welcome to Hades." );
	}
	if ( who && option( "Why are you hanging around here?" ) )
	{
		saywait( soul, "Well, I'm supposed to get on the boat\nand cross over the river." );
		saywait( soul, "But, you need a coin to pay the ferryman." );
		saywait( player, "Don't you have one?" );
		saywait( soul, "Nope. They were supposed to bury me with one,\nbut I guess they forgot." );
coins: options();
		if ( option( "Well that sucks." ) )
		{
			saywait( soul, "Tell me about it." );
			goto start;
		}
		if ( option( "I'd lend you one but I'm all out." ) )
		{
			saywait( soul, "Figures. Well, if you come across any, let me know." );
			goto start;
		}
		if ( option( "So you're just going to wait here till the end of time?" ) )
		{
			saywait( soul, "Oh, no! I'm sure it won't be long." );
			saywait( soul, "I'll just keep waiting a little longer." );
			saywait( soul, "Yes... just a little longer..." );
			howlong = true;
			goto start;
		}
		goto coins;
	}
	if ( howlong && optiononce( ID, "How long have you been waiting so far?" ) )
	{
		saywait( soul, "I'm not sure." );
		saywait( soul, "What year is it?" );
		goto start;
	}
	if ( option( "I guess I'll be running along now." ) )
	{
		saywait( soul, "I'll just wait here." );
		soul->dir = DIR_DOWN;
		return;
	}
	goto start;
}

void charonExit()
{
	walkto( charon, 45, 82 );
	waitwalk( charon );
	scriptDelete( charon );
	charon = NULL;
	door->x = 45;
	door->tx = 45;
}

void talkCharon()
{
	lookat( charon, player );
	conversation();

	static bool first = true;
	static bool problem = false;
	static uint convinceCount = 0;

	if ( first )
	{
		saywait( charon, "Well? What do you want?" );
		saywait( player, "There's been a terrible misunderstanding here." );
		saywait( charon, "How so?" );
		saywait( player, "I'm not Greek, I'm Swedish. I shouldn't be in Hades." );
		saywait( charon, "Not my problem." );
		saywait( player, "But I'm not even dead!" );
		saywait( charon, "That's what they all say." );
		first = false;
	} else {
		saywait( charon, "Oh, it's you again." );
	}

start: options();
	if ( optiononce( ID, "Are you the ferryman?" ) )
	{
		saywait( charon, "Ah, so you must be the brains of\nthis operation." );
		saywait( charon, "Yes, I am the ferryman." );
		goto start;
	}
	if ( option( "Can you take me across the river?" ) )
	{
		if ( convinced )
			goto willtake;

		if ( numTimesCrossed == 0 )
		{
			saywait( charon, "Hmm..." );
			saywait( charon, "Well I could, except..." );
			saywait( charon, "You said you weren't Greek?" );
			saywait( charon, "Greeks only in Hades. No Swedes." );
			problem = true;
			goto start;
		} else if ( numTimesCrossed == 1 ) {
			saywait( charon, "Well I could, except..." );
			saywait( charon, "You said you weren't Greek?" );
			saywait( charon, "Wait, hang on, we've had this\nargument already." );
			saywait( charon, "Are you Greek or not?" );
amgreek: options();
			if ( option( "Oh sure. Greek all the way. That's me." ) )
			{
				saywait( charon, "Fine, whatever." );
				saywait( charon, "Get in the boat, I'll take you across." );
				goto willtake;
			}

			if ( option( "To be honest, no." ) )
			{
				saywait( charon, "Well away with you then." );
				charonExit();
				return;
			}
			goto amgreek;
		} else {
			saywait( charon, "You know what, I don't even care any more." );
			goto willtake;
		}
	}
	if ( problem && option( "I was wrong earlier. I'm actually Greek." ) )
	{
		saywait( charon, "You don't look very Greek." );
convince: options();
		if ( convinceCount == 3 )
		{
			saywait( charon, "Fine, whatever." );
			saywait( charon, "Get in the boat, I'll take you across." );
			saywait( charon, "Anything to make you go away." );
			saywait( charon, "I can't bear the thought of you being stuck\non this shore for eternity anyway." );
			goto willtake;
		}

		if ( optiononce( ID, "My real name is Mr. Pythagoras." ) )
		{
			saywait( charon, "I think he's already here somewhere." );
			convinceCount++;
			goto convince;
		}
		if ( optiononce( ID, "I went on vacation to Zakinthos once." ) )
		{
			saywait( charon, "Oh, so a real local then." );
			convinceCount++;
			goto convince;
		}
		if ( optiononce( ID, "I've eaten hundreds of kebabs." ) )
		{
			saywait( charon, "That's nothing to be proud of." );
			convinceCount++;
			goto convince;
		}
		if ( option( "Never mind." ) )
			goto start;
		goto convince;
	}
	if ( option( "There really has been a misunderstanding here." ) )
	{
		saywait( charon, "How so?" );
mistake: options();
		if ( option( "Why would a Swedish person end up in Hades?" ) )
		{
			saywait( charon, "I don't know." );
			saywait( charon, "Maybe you took a wrong turn at Albuquerque." );
			goto start;
		}
		if ( option( "I'm not dead." ) )
		{
			saywait( charon, "Heard it." );
			saywait( charon, "You'll get used to it, don't worry." );
whydead: options();
			if ( option( "What did I die of?" ) )
			{
				saywait( charon, "Hey, I just run the ferry." );
				goto whydead;
			}
			if ( option( "I don't remember dying." ) )
			{
				saywait( charon, "And yet here you are." );
				saywait( charon, "I'm sure whatever it was,\nit was worth it." );
				goto whydead;
			}
			if ( option( "Never mind." ) )
				goto start;
			goto whydead;
		}
		goto mistake;
	}
	if ( option( "I'll just run along now." ) )
	{
		saywait( charon, "You do that." );
		charonExit();
		return;
	}
	goto start;

willtake:
	if ( !takenCoin )
	{
		static bool first = true;
		if ( first )
			saywait( charon, "Oh wait, what am I thinking?" );
		first = false;

		saywait( charon, "Do you have a coin?" );

		if ( has( "coin" ) )
		{
			saywait( player, "Yep, sure do." );
			saywait( charon, "I'll just take that." );
			player->anim = ANIM_USE;
			wait( 30 );
			player->anim = ANIM_IDLE;
			scriptTake( "coin" );
			saywait( charon, "OK, let's go." );
			takenCoin = true;
			problem = false;
		} else {
			saywait( player, "A coin? Um... no." );
			saywait( charon, "You need a coin to pay the ferryman.\nDon't you know anything.");
			saywait( charon, "Come back when you have one." );
			goto start;
		}
	}

	numTimesCrossed++;
	wait( 60 );
	scriptSetScene( SCENE_FIELD );
	return;
}

Result eventShores()
{
	if ( command.verb == VERB_GIVE )
	{
		if ( command.a.got && !strcmp( command.a.got->name, "coin" ) )
		{
			if ( command.b.actor && command.b.actor == soul )
			{
				saywait( player, "This coin might be my only\nticket out of here." );
				say( player, "I'm not giving it to this idiot." );
				return DONE;
			}
		}
	}

	Actor *target = command.a.actor;
	if ( target )
	{
		if ( target == soul )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				lookat( player, target );
				static bool first = true;
				if ( first )
				{
					saywait( player, "Yikes!" );
					player->dir = DIR_DOWN;
					first = false;
				}
				say( player, "I think it's a ghost." );
				return DONE;
			}
			if ( command.verb == VERB_TALKTO )
			{
				if ( standBy( player, soul ) )
				{
					talkSoul();
					return DONE;
				}
				return NOTDONE;
			}
		}

		if ( target == cavern )
		{
			if ( command.verb == VERB_WALK )
			{
				if ( !standBy( player, cavern ) )
					return NOTDONE;
				
				scriptSetScene( SCENE_CAVERN );
				return DONE;
			}
			if ( command.verb == VERB_LOOKAT )
			{
				say( player, "It's a dark, mysterious cave." );
				return DONE;
			}
		}

		if ( target == sign )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, sign ) )
					return NOTDONE;

				saywait( player, "\"SECRET EXIT TO OVERWORLD\"" );
				saywait( player, "\"WARNING: No trespassing.\"" );
				say( player, "\"By Order -- Hades.\"" );
				return DONE;
			}
		}

		if ( target == door )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, door ) )
					return NOTDONE;

				say( player, "There's a little wooden shack here.\nThe door's shut." );
				return DONE;
			}
			if ( command.verb == VERB_USE )
			{
				if ( !standBy( player, door ) )
					return NOTDONE;


				saywait( player, "I'll just knock." );
				player->dir = DIR_UP;
				saywait( door, "<KNOCK>" );

				door->x = -100;

				charon = scriptSpawn( "ferrymaster", 45, 82, 0, 0, &costumeGhost, FLAG_MAN );
				walkto( player, 80, 85 );
				walkto( charon, 45, 87 );
				waitwalk( player );
				waitwalk( charon );
				lookat( player, charon );
				talkCharon();

				return DONE;
			}
		}
	}

	return UNKNOWN;
}

void __stdcall sceneShores( void *param )
{
	if ( gamePrevScene == SCENE_CAVERN )
		ragnar = scriptSpawn( NULL, 275, 99, 0, 0, &costumeRagnar, 0 );
	else if ( gamePrevScene == SCENE_FIELD )
		ragnar = scriptSpawn( NULL, 118, 82, 0, 0, &costumeRagnar, 0 );
	else
		ragnar = scriptSpawn( NULL, 200, 117, 0, 0, &costumeRagnar, 0 );
	soul = scriptSpawn( "ghost", 25, 119, 0, 0, &costumeGhost, FLAG_MAN );
	cavern = scriptSpawn( "cavern", 277, 97, 52, 42, NULL, FLAG_EXIT|FLAG_FIXED );
	sign = scriptSpawn( "sign", 241, 97, 18, 30, NULL, FLAG_FIXED );
	door = scriptSpawn( "door", 45, 83, 24, 36, &costumeDoor, FLAG_FIXED );
	charon = NULL;

	player = ragnar;
	convinced = false;

	uint timer = 0;

	if ( firstTime )
	{
		saywait( player, "?" );
		player->dir = DIR_LEFT;
		wait( 120 );
		player->dir = DIR_RIGHT;
		wait( 120 );
		player->dir = DIR_DOWN;
		saywait( player, "Where am I?" );
		saywait( player, "How did I get here?" );
		firstTime = false;
	}

	while( true )
	{
		updateGame();

		if ( soul->anim == ANIM_IDLE )
		{
			if ( timer > 0 )
			{
				timer--;
			} else {
				walkto( soul, 25 + rand()%150, 109 + rand()%10 );
				timer = 200 + rand()%200;
			}
		}

		if ( command.exists )
		{
			Result r = eventShores();
			if ( r == UNKNOWN )
				r = scriptDefaultLogic();
			if ( r == DONE )
				command.exists = false;
		}
	}
}

