#include "ludum.h"

static Actor *ragnar;
static Actor *exitL;
static Actor *exitR;
static Actor *squirrel;
static Actor *ghosts[3];

static bool hasSquirrel = false;
static bool gaveNuts = false;

static void msg( Actor *ghost )
{
	int i = rand() & 7;
	const char *text[] = {
		"... blood ...",
		"... death ...",
		"... die ...",
		"... pain ...",
		"... fear ...",
		"... I see you ...",
		"... alive ...",
		"... eternity ...",
	};
	say( ghost, text[i] );
}

Result eventField()
{
	if ( squirrel && command.verb == VERB_GIVE && command.b.actor && command.b.actor == squirrel )
	{
		walkto( player, 100, 86 );
		waitwalk( player );

		Got *nuts = command.a.got;
		if ( !nuts || strcmp( nuts->name, "nuts" ) )
		{
			say( player, "I'm not sure that's the kind of thing\na squirrel would like." );
			return DONE;
		}

		walkto( player, 46, 89 );
		waitwalk( player );
		saywait( player, "Here you go, little fella." );
		walkto( squirrel, 34, 31 );
		waitwalk( squirrel );
		squirrel->x = squirrel->tx = 27;
		squirrel->y = squirrel->ty = 61;
		squirrel->dir = DIR_RIGHT;

		say( squirrel, "!" );
		scriptTake( "nuts" );
		gaveNuts = true;
		return DONE;
	}

	Actor *target = command.a.actor;
	if ( target )
	{
		if ( squirrel && target == squirrel )
		{
			if ( command.verb == VERB_GIVE )
				return UNKNOWN;

			if ( gaveNuts )
				walkto( player, 46, 89);
			else
				walkto( player, 100, 86 );
			waitwalk( player );

			if ( command.verb == VERB_LOOKAT )
			{
				say( player, "It's a darling little squirrel." );
			}

			if ( command.verb == VERB_PICKUP )
			{
				if ( !gaveNuts )
				{
					say( player, "I can't reach it." );
				} else {
					scriptGive( "squirrel", 1, 0 );
					scriptDelete( squirrel );
					squirrel = NULL;
					hasSquirrel = true;
				}
			}

			if ( command.verb == VERB_USE )
			{
				saywait( player, "I can't reach it." );
				say( player, "Besides, how do you use a squirrel?" );
			}

			return DONE;
		}

		if ( target == exitL )
		{
			if ( command.verb == VERB_WALK )
			{
				if ( !standBy( player, exitL ) )
					return NOTDONE;
				
				scriptSetScene( SCENE_BEYOND );
				return DONE;
			}
			if ( command.verb == VERB_LOOKAT )
			{
				say( player, "It's a path out of this field." );
				return DONE;
			}
		}

		if ( target == exitR )
		{
			if ( command.verb == VERB_WALK )
			{
				if ( !standBy( player, exitR ) )
					return NOTDONE;

				static bool first = true;
				if ( first )
				{
					player->dir = DIR_DOWN;
					wait( 60 );
					saywait( player, "I'll just convince him I'm not Greek,\nand he'll probably take me back." );
					saywait( player, "No problem." );
					wait( 60 );
					first = false;
				}
				
				scriptSetScene( SCENE_SHORES );
				return DONE;
			}
			if ( command.verb == VERB_LOOKAT )
			{
				say( player, "It leads back to the ferry." );
				return DONE;
			}
		}

		for (uint n=0;n<3;n++)
		{
			Actor *ghost = ghosts[n];
			if ( target == ghost )
			{
				if ( command.verb == VERB_LOOKAT )
				{
					if ( !standBy( player, ghost ) )
						return NOTDONE;

					say( player, "I can feel it staring at me." );
					return DONE;
				}

				if ( command.verb == VERB_TALKTO )
				{
					if ( !standBy( player, ghost ) )
						return NOTDONE;

					saywait( player, "Hello?" );
					saywait( player, "Are you OK?" );
					wait( 60 );
					msg( ghost );
					return DONE;
				}

				if ( command.verb == VERB_USE || command.verb == VERB_PICKUP )
				{
					player->dir = DIR_DOWN;
					say( player, "No way. I'm not touching these things." );
					return DONE;
				}
			}
		}
	}

	return UNKNOWN;
}

void __stdcall sceneField( void *param )
{
	if ( gamePrevScene == SCENE_BEYOND )
		ragnar = scriptSpawn( NULL, 12, 123, 0, 0, &costumeRagnar, 0 );
	else
		ragnar = scriptSpawn( NULL, 273, 87, 0, 0, &costumeRagnar, 0 );

	if ( !gaveNuts )
		squirrel = scriptSpawn( "squirrel", 38, 31, 0, 0, &costumeSquirrel, 0 );
	else if ( !hasSquirrel )
		squirrel = scriptSpawn( "squirrel", 27, 61, 0, 0, &costumeSquirrel, 0 );
	else
		squirrel = NULL;
	exitL = scriptSpawn( "path", 15, 127, 37, 25, NULL, FLAG_EXIT|FLAG_FIXED );
	exitR = scriptSpawn( "path to ferry", 265, 85, 65, 25, NULL, FLAG_EXIT|FLAG_FIXED );
	
	ghosts[0] = scriptSpawn( "soul", 152, 76, 0, 0, &costumeSoul, FLAG_MAN );
	ghosts[1] = scriptSpawn( "soul", 141, 113, 0, 0, &costumeSoul, FLAG_MAN );
	ghosts[2] = scriptSpawn( "soul", 277, 108, 0, 0, &costumeSoul, FLAG_MAN );

	player = ragnar;

	uint timer = 0;

	while( true )
	{
		updateGame();

		if ( !gaveNuts && squirrel->anim == ANIM_IDLE )
		{
			if ( timer > 0 )
			{
				timer--;
			} else {
				walkto( squirrel, 38 + rand()%40, 31 );
				timer = 50 + rand()%50;
			}
		}

		if ( ( rand() & 511 ) == 0 )
		{
			uint i = rand();
			msg( ghosts[i%3] );
		}

		if ( command.exists )
		{
			Result r = eventField();
			if ( r == UNKNOWN )
				r = scriptDefaultLogic();
			if ( r == DONE )
				command.exists = false;
		}
	}
}

