#include "ludum.h"

static Actor *ragnar;
static Actor *dog;
static Actor *heads[3];
static Actor *exitL, *exitR;
static Actor *corpse;
static Actor *coin;
static Actor *guard;

static bool firstTime = true;
static bool foundCoin = false;
static bool gaveRibs = false;
static bool gaveSquirrel = false;
static bool gaveBone = false;

static uint dogFed()
{
	uint count = 0;
	if ( gaveRibs )
		count++;
	if ( gaveSquirrel )
		count++;
	if ( gaveBone )
		count++;
	return count;
}

Result eventCavern()
{
	if ( command.verb == VERB_GIVE && command.b.actor == dog )
	{
		Got *item = command.a.got;
		if ( !item )
			return UNKNOWN;

		if ( strcmp( item->name, "BBQ ribs" ) && strcmp( item->name, "bone" ) && strcmp( item->name, "squirrel" ) )
		{
			say( player, "That probably won't keep him busy." );
			return DONE;
		}

		walkto( player, 150, 119 );
		waitwalk( player );
		player->dir = DIR_RIGHT;
		player->anim = ANIM_USE;
		wait( 60 );
		player->anim = ANIM_IDLE;

		if ( !strcmp( item->name, "BBQ ribs" ) )
			gaveRibs = true;
		if ( !strcmp( item->name, "bone" ) )
			gaveBone = true;
		if ( !strcmp( item->name, "squirrel" ) )
		{
			wait( 240 );
			player->dir = DIR_DOWN;
			saywait( player, "I'm sure he's not going to eat the squirrel." );
			saywait( player, "He'll probably just watch it for a little." );
			wait( 240 );
			saywait( player, "I'm sure he won't eat it." );
			gaveSquirrel = true;
		}

		scriptTake( item->name );
		
		if ( dogFed() == 1 )
			say( player, "Well, that's one head occupied." );
		if ( dogFed() == 2 )
			say( player, "Only one head to go now." );
		if ( dogFed() == 3 )
			say( player, "He's distracted now. I could probably pass." );

		return DONE;
	}

	Actor *target = command.a.actor;
	if ( target )
	{
		if ( target == exitL )
		{
			if ( command.verb == VERB_WALK )
			{
				if ( !standBy( player, exitL ) )
					return NOTDONE;
				
				scriptSetScene( SCENE_SHORES );
				return DONE;
			}
			if ( command.verb == VERB_LOOKAT )
			{
				say( player, "It leads back out to where I started." );
				return DONE;
			}
		}

		if ( target == exitR )
		{
			if ( command.verb == VERB_WALK )
			{
				if ( !standBy( player, exitR ) )
					return NOTDONE;

				scriptDelete( player );
				wait( 60 );
				guard = scriptSpawn( NULL, 3, 122, 0, 0, &costumeGhost, FLAG_MAN );
				walkto( guard, 30, 122 );
				waitwalk( guard );
				saywait( guard, "Damn, there goes another one." );
				saywait( guard, "I should just install a revolving\ndoor in this place." );
				wait( 60 );
				
				scriptSetScene( SCENE_END );
				return DONE;
			}
			if ( command.verb == VERB_LOOKAT )
			{
				say( player, "I think that's where I need to be." );
				return DONE;
			}
		}

		if ( target == dog )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				saywait( player, "That's the second-biggest dog I've ever seen." );
				if ( dogFed() == 0 )
					saywait( player, "I could probably get past if I had\nsomething to distract him." );
				else if ( dogFed() == 1 ) 
					saywait( player, "One of the heads is busy with the toy I gave it." );
				else if ( dogFed() == 2 ) 
					saywait( player, "Two of the heads are busy with the toys I gave it." );
				else
					saywait( player, "I think it's distracted now. I could possibly get past." );

				return DONE;
			}
		}
		if ( target == corpse )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, corpse ) )
					return NOTDONE;

				saywait( player, "It's the remains of a previous adventurer." );
				wait( 60 );
				saywait( player, "Wait, hang on. How could you even die here?" );
				saywait( player, "Where would you go?" );
				return DONE;
			}

			if ( command.verb == VERB_PICKUP )
			{
				if ( !standBy( player, corpse ) )
					return NOTDONE;

				if ( has( "bone" ) )
				{
					say( player, "I already have enough of him." );
				} else {
					saywait( player, "Most of him's crumbled, but\nI can take his leg bone here." );
					scriptGive( "bone", 1, 0 );
				}
				return DONE;
			}
		}

		if ( !foundCoin && target == coin )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, coin ) )
					return NOTDONE;

				say( player, "It looks like this guy left his coin behind." );
				return DONE;
			}

			if ( command.verb == VERB_PICKUP )
			{
				if ( !standBy( player, coin ) )
					return NOTDONE;

				player->anim = ANIM_USE;
				wait( 60 );
				say( player, "This should come in handy." );
				scriptGive( "coin", 1, 0 );
				scriptDelete( coin );
				foundCoin = true;
				return DONE;
			}
		}
	}

	return UNKNOWN;
}

void __stdcall sceneCavern( void *param )
{
	ragnar = scriptSpawn( NULL, 3, 122, 0, 0, &costumeRagnar, 0 );
	exitL = scriptSpawn( "entrance", 6, 114, 15, 45, NULL, FLAG_EXIT|FLAG_FIXED );
	exitR = scriptSpawn( "passageway", 313, 101, 22, 56, NULL, FLAG_EXIT|FLAG_FIXED );
	corpse = scriptSpawn( "skeleton", 102, 117, 20, 22, NULL, FLAG_FIXED );
	dog = scriptSpawn( "three-headed dog", 222, 107, 76, 49, NULL, 0 );
	heads[0] = scriptSpawn( NULL, 189, 79, 0, 0, &costumeDogHead, 0 );
	heads[1] = scriptSpawn( NULL, 215, 83, 0, 0, &costumeDogHead, 0 );
	heads[2] = scriptSpawn( NULL, 244, 81, 0, 0, &costumeDogHead, 0 );

	if ( !foundCoin )
		coin = scriptSpawn( "coin", 113, 119, 5, 5, &costumeCoin, 0 );

	player = ragnar;

	walkto( player, 20, 122 );

	if ( firstTime )
	{
		wait( 50 );
		lookat( player, dog );
		saywait( player, "Whoa. A three-headed dog." );
		player->dir = DIR_DOWN;
		saywait( player, "Well there's something you don't see every day." );
		player->dir = DIR_RIGHT;
		firstTime = false;
	}

	while( true )
	{
		updateGame();

		if ( player->x >= 160 && dogFed() < 3 )
		{
			command.exists = false;

			walkto( player, 126, 124 );
			waitwalk( player );
			player->dir = DIR_DOWN;
			saywait( player, "I'd better not get any closer." );
			if ( dogFed() == 0 )
				saywait( player, "He looks hungry." );
			else
				saywait( player, "He still looks hungry." );
		}

		if ( command.exists )
		{
			Result r = eventCavern();
			if ( r == UNKNOWN )
				r = scriptDefaultLogic();
			if ( r == DONE )
				command.exists = false;
		}
	}
}

