#include "ludum.h"

static Actor *ragnar;
static Actor *exit;
static Actor *demon;
static Actor *cook;
static Actor *nuts;
static Actor *pit;

static bool needsFire = false;
static bool demonGone = false;
static uint demonTimer;
static bool triedBeg = false;
static bool gotFire = false;

void talkDemon()
{
	lookat( demon, player );
	conversation();

	static bool first = true;
	bool hello = false;
	bool prisoner = false;

start: options();
	if ( !hello )
	{
		if ( first )
		{
			if ( option( "Hello." ) )
			{
				saywait( demon, "DO NOT BOTHER ME." );
				hello = true;
				first = false;
				goto start;
			}
		} else {
			if ( option( "Hello again." ) )
			{
				saywait( demon, "WHY DO YOU PESTER ME SO." );
				hello = true;
				goto start;
			}
		}
	}

	if ( needsFire && !has( "fire and brimstone" ) )
	{
		if ( option( "I need some of your fire to light the BBQ." ) )
		{
			saywait( demon, "Sorry. I need it all to power the hellpit." );
beg: options();
			if ( option( "Please?" ) )
			{
				triedBeg = true;
				static int no = 0;
				if ( no++ == 5 )
					saywait( demon, "Look, no means no, OK?" );
				else
					saywait( demon, "No." );
				goto start;
			}
			if ( option( "I'll bring it right back." ) )
			{
				triedBeg = true;
				saywait( demon, "Hah! You could be gone for hours!" );
				saywait( demon, "My fire could completely have gone out\nby the time you bring it back." );
				goto start;
			}
			if ( option( "Go on, be a sport." ) )
			{
				triedBeg = true;
				saywait( demon, "I'm a hell demon." );
				saywait( demon, "I don't do nice." );
				goto start;
			}
			if ( option( "Fine. I didn't want it anyway." ) )
				goto start;
			goto beg;
		}
	}

	if ( triedBeg && option( "Look behind you! A three-headed dog!") )
	{
		saywait( demon, "I'm not falling for that one." );

fool: options();
		if ( !prisoner && option( "Look! An escaping prisoner!" ) )
		{
			saywait( demon, "You're not fooling anyone here." );
			prisoner = true;
			goto fool;
		}

		if ( prisoner && option( "No really, I can see him." ) )
		{		
			saywait( demon, "Really? Hmm..." );
			saywait( demon, "I'd better go check it out." );
			walkto( demon, 1, 92 );
			waitwalk( demon );
			walkto( demon, 21, 92 );
			waitwalk( demon );
			saywait( demon, "DON'T touch anything while I'm gone." );
			saywait( player, "Of course not." );
			walkto( demon, 1, 92 );
			waitwalk( demon );
			demon->x = -100;
			demonGone = true;
			demonTimer = 200;
			return;
		}

		if ( option( "Are you really not going to budge on this?" ) )
		{
			saywait( demon, "There's nothing you can do\nto get rid of me. ");
			goto start;
		}
		goto fool;
	}
		
	if ( option( "Goodbye." ) )
		return;

	goto start;
}

void talkCook()
{
	lookat( cook, player );
	conversation();

start: options();
	if ( option( "Why are you having a BBQ here?" ) )
	{
		saywait( cook, "Hey, it's heaven, isn't it?" );
		goto start;
	}

	if ( option( "Can I have some of your BBQ'd ribs?" ) )
	{
		saywait( cook, "I'd love to, but we can't light the BBQ." );
		saywait( cook, "That mean demon won't give me any fire." );
		needsFire = true;
		goto start;
	}

	if ( option( "Goodbye." ) )
	{
		cook->dir = DIR_RIGHT;
		return;
	}

	goto start;
}

Result eventBeyond()
{
	if ( command.verb == VERB_GIVE )
	{
		if ( command.b.actor && command.b.actor == cook )
		{
			if ( command.a.got && !strcmp( command.a.got->name, "fire and brimstone" ) )
			{
				if ( !standBy( player, cook ) )
					return NOTDONE;

				lookat( cook, player );
				saywait( cook, "Aha! Now I can start the BBQ. Thanks." );
				wait( 120 );
				saywait( cook, "Here, help yourself to some ribs." );

				scriptGive( "BBQ ribs", 1, 0 );
				scriptTake( "fire and brimstone" );
				return DONE;
			}
		}
	}

	Actor *target = command.a.actor;
	if ( target )
	{
		if ( target == exit )
		{
			if ( command.verb == VERB_WALK )
			{
				if ( !standBy( player, exit ) )
					return NOTDONE;
				
				scriptSetScene( SCENE_FIELD );
				return DONE;
			}
			if ( command.verb == VERB_LOOKAT )
			{
				say( player, "It goes back to that strange field." );
				return DONE;
			}
		}

		if ( target == demon )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, demon ) )
					return NOTDONE;

				say( player, "He's stoking the fire for that infernal pit." );
				return DONE;
			}

			if ( command.verb == VERB_TALKTO )
			{
				if ( !standBy( player, demon ) )
					return NOTDONE;

				talkDemon();
				return DONE;
			}
		}

		if ( target == cook )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, cook ) )
					return NOTDONE;

				say( player, "He's setting up a BBQ." );
				return DONE;
			}

			if ( command.verb == VERB_TALKTO )
			{
				if ( !standBy( player, cook ) )
					return NOTDONE;

				talkCook();
				return DONE;
			}
		}

		if ( target == nuts )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, nuts ) )
					return NOTDONE;

				say( player, "Assorted walnuts, brazils, and cashews." );
				return DONE;
			}

			if ( command.verb == VERB_PICKUP )
			{
				if ( !standBy( player, nuts ) )
					return NOTDONE;

				if ( has( "nuts" ) )
				{
					say( player, "I already have some." );
				} else {
					say( player, "I'll grab a handful." );
					scriptGive( "nuts", 1, 0 );
				}
				return DONE;
			}
		}

		if ( target == pit )
		{
			if ( command.verb == VERB_LOOKAT )
			{
				if ( !standBy( player, pit ) )
					return NOTDONE;

				saywait( player, "This must be where all the bad people get thrown into." );
				lookat( demon, player );
				saywait( demon, "We also use it for central heating.\nIt's very convienient." );
				demon->dir = DIR_UP;
				return DONE;
			}

			if ( command.verb == VERB_USE )
			{
				say( player, "I don't think hurling myself in will solve anything." );
				return DONE;
			}

			if ( command.verb == VERB_PICKUP )
			{
				if ( !standBy( player, pit ) )
					return NOTDONE;

				if ( gotFire )
				{
					say( player, "I already have all I need." );
					return DONE;
				}

				if ( demonGone )
				{
					scriptGive( "fire and brimstone", 1, 0 );
					say( player, "Hah! Got it." );
					gotFire = true;
				} else {
					stop( player );
					walkto( player, 85, 100 );
					say( demon, "Hey! Get away from that." );
				}

				return DONE;
			}
		}
	}

	return UNKNOWN;
}

void __stdcall sceneBeyond( void *param )
{
	ragnar = scriptSpawn( NULL, 254, 129, 0, 0, &costumeRagnar, 0 );
	exit = scriptSpawn( "exit", 228, 129, 88, 26, NULL, FLAG_EXIT|FLAG_FIXED );
	demon = scriptSpawn( "demon", 21, 92, 0, 0, &costumeGhost, FLAG_MAN );
	cook = scriptSpawn( "BBQ chef", 269, 89, 0, 0, &costumeGhost, FLAG_MAN );
	nuts = scriptSpawn( "bowl of nuts", 229, 77, 19, 26, NULL, 0 );
	pit = scriptSpawn( "pit of hellfire and damnation", 61, 89, 64, 28, NULL, FLAG_EXIT ); // exit hack
	cook->dir = DIR_RIGHT;
	demon->dir = DIR_UP;

	player = ragnar;
	demonGone = false;

	walkto( player, 180, 108 );

	while( true )
	{
		updateGame();

		if ( demonGone )
		{
			demonTimer--;
			if ( demonTimer == 0 )
			{
				demonGone = false;
				demon->x = demon->tx = 10;
				demon->dir = DIR_RIGHT;
				command.exists = false;

				saywait( demon, "Hey! There's no-one over there!" );
				walkto( demon, 21, 92 );
				waitwalk( demon );
				saywait( demon, "I'm onto you." );
				demon->dir = DIR_UP;
			}
		}

		if ( command.exists )
		{
			Result r = eventBeyond();
			if ( r == UNKNOWN )
				r = scriptDefaultLogic();
			if ( r == DONE )
				command.exists = false;
		}
	}
}

