#pragma once

#define NULL    0
#define SCREEN_WIDTH		320
#define SCREEN_HEIGHT		200
#define WINDOW_WIDTH		320
#define WINDOW_HEIGHT		130

#define USE_MUSIC

//#define DEBUG_ACTORS

typedef   signed char  s8;
typedef   signed short s16;
typedef   signed int   s32;
typedef unsigned char  u8;
typedef unsigned short u16;
typedef unsigned int   u32;
typedef unsigned int   uint;

#define ID		( ((u32)__FILE__) ^ ( __COUNTER__ << 16 ) )

template<typename T> T min( T a, T b ) { return ( a < b ) ? a : b; }
template<typename T> T max( T a, T b ) { return ( a > b ) ? a : b; }

#define COLOR_BLACK		16
#define COLOR_DKGRAY	17
#define COLOR_LTGRAY	18
#define COLOR_WHITE		19

struct LBitmap
{
	uint w, h;

	u8 *pixels;
};

enum Scenes
{
	SCENE_CAVERN = 1,
	SCENE_FIELD = 10,
	SCENE_SHORES = 7,
	SCENE_BEYOND = 13,
	SCENE_END = 16,
	SCENE_TITLE = 19,
};

enum Verb
{
	VERB_WALK,
	VERB_LOOKAT,
	VERB_TALKTO,
	VERB_USE,
	VERB_PICKUP,
	VERB_GIVE,

	NVERBS
};

enum Anim
{
	ANIM_IDLE,
	ANIM_WALK,
	ANIM_TALK,
	ANIM_USE,
};

enum Dir
{
	DIR_LEFT,
	DIR_UP,
	DIR_RIGHT,
	DIR_DOWN,
};

#define FLAG_MAN		(1<<0)
#define FLAG_EXIT		(1<<1)
#define FLAG_FIXED		(1<<2)

#define COSTUME_END	{ ANIM_IDLE, DIR_LEFT, 0 }

struct CostumeTable
{
	Anim anim;
	Dir dir;
	int frame;
};

struct Costume
{
	u8 color;
	int hotx, hoty;
	int sprW, sprH;
	int defW, defH;
	const u8 *incbin;

	CostumeTable table[30];

	LBitmap *frames[2][30];
};

struct Actor
{
	bool valid;
	const char *name;
	int x, y;
	int w, h;
	u32 flags;

	Anim anim;
	Dir dir;
	int tx, ty;
	const char *saying;
	uint sayTicks;
	int sayx, sayy;
	uint cycle;
	uint blockedTicks;

	Costume *costume;
};

struct Got
{
	const char *name;
	u32 flags;
	uint timestamp;
};

struct Noun
{
	Actor *actor;
	Got *got;
};

struct Command
{
	bool exists;
	bool hasSecond, needSecond;
	Verb verb;
	Noun a, b;
	int x, y;
};

enum Result
{
	UNKNOWN,
	DONE,
	NOTDONE
};

LBitmap *lbmpNew( uint w, uint h );
void lbmpFree( LBitmap *bmp );
void lbmpClear( LBitmap *bmp, u8 color );
void lbmpRect( LBitmap *bmp, int dx, int dy, int w, int h, u8 color );
void lbmpRectFill( LBitmap *bmp, int dx, int dy, int w, int h, u8 color );
void lbmpBlit( LBitmap *dest, LBitmap *src, int dx, int dy, int sx, int sy, int w, int h );
void lbmpBlitMasked( LBitmap *dest, LBitmap *src, int dx, int dy, int sx, int sy, int w, int h );
void lbmpBlitReplace( LBitmap *dest, LBitmap *src, int dx, int dy, int sx, int sy, int w, int h, u8 color );

uint anmGetNumFrames( const u8 *data );
void anmGetPalette( const u8 *data, u32 *palette );
void anmDecode( uint frame, const u8 *data );
LBitmap *anmGetBitmap( uint w, uint h );

void fontPrint( int x, int y, u8 c, const char *text );
void fontPrint2( int x, int y, u8 c, const char *text, uint count );

void musicStartup( const u8 *data );
void musicShutdown();

void gameStartup();
void gameUpdate();

typedef void __stdcall ScriptThread( void *param );

void *scriptNew( ScriptThread *fn, void *data, bool local );
void scriptWaitText( Actor *actor );
void scriptSetScene( uint scene );
Actor *scriptSpawn( const char *name, int x, int y, int w, int h, Costume *costume, u32 flags );
void scriptDelete( Actor *actor );
void scriptStartup();
void scriptPrepareScene( uint scene );
Got *scriptGive( const char *name, uint max, u32 flags );
void scriptTake( const char *name );
Result scriptDefaultLogic();

void wait( uint ticks );
void waitwalk( Actor *actor );
void walkto( Actor *actor, int x, int y );
void say( Actor *actor, const char *text );
void saywait( Actor *actor, const char *text );
void lookat( Actor *actor, Actor *target );
void stop( Actor *actor );
bool standBy( Actor *actor, Actor *target );
u32 getFlags( Noun noun );
bool has( const char *name );
void updateGame();

void conversation();
void options();
bool option( const char *text );
bool optiononce( u32 id, const char *text );

bool operator==( Noun a, Noun b );
bool operator==( Noun a, Actor *b );
bool operator==( Noun a, Got *b );

extern Command command;
extern Noun gameHoverNoun;
extern uint gamePrevScene;
extern uint gameClickTime;
extern bool gameUiVisible;

extern Actor *player;

extern LBitmap *hwScreen;
extern u32 hwPalette[256]; // ARGB

extern bool mouseDown;
extern int mouseX, mouseY;

extern Costume costumeRagnar;
extern Costume costumeGhost;
extern Costume costumeCoin;
extern Costume costumeDogHead;
extern Costume costumeDoor;
extern Costume costumeSoul;
extern Costume costumeSquirrel;

ScriptThread sceneShores;
ScriptThread sceneCavern;
ScriptThread sceneField;
ScriptThread sceneBeyond;
ScriptThread sceneEnd;
ScriptThread sceneTitle;

// Libc replacement.
extern "C" void *memset( void *dst, int val, size_t size );
extern "C" void *memcpy( void *dst, const void *src, size_t size );
extern "C" int rand();
extern "C" int abs( int n );
extern "C" int strcmp( const char *c, const char *b );
#pragma function( memset, memcpy, abs, strcmp )

