#include "ludum.h"

LBitmap *lbmpNew( uint w, uint h )
{
	LBitmap *bmp = new LBitmap;
	bmp->w = w;
	bmp->h = h;
	bmp->pixels = new u8[w*h];
	return bmp;
}

void lbmpFree( LBitmap *bmp )
{
	delete[] bmp->pixels;
	delete bmp;
}

void lbmpClear( LBitmap *bmp, u8 color )
{
	uint n = bmp->w*bmp->h;
	u8 *dest = bmp->pixels;
	while( n-- )
		*dest++ = color;
}

void lbmpClip( LBitmap *dest, LBitmap *src, int &dx, int &dy, int &sx, int &sy, int &w, int &h )
{
	int offsetx = sx - dx;
	int offsety = sy - dy;

	int dx1 = dx + w;
	int dy1 = dy + h;
	dx = max( dx, 0 );
	dy = max( dy, 0 );
	dx1 = min( dx1, (int)dest->w );
	dy1 = min( dy1, (int)dest->h );

	w = dx1 - dx;
	h = dy1 - dy;

	sx = dx + offsetx;
	sy = dy + offsety;

	if ( sx < 0 )
	{
		dx -= sx;
		w += sx;
		sx = 0;
	}

	if ( sy < 0 )
	{
		dy -= sy;
		h += sy;
		sy = 0;
	}

	if ( sx + w > (int)src->w )
		w = src->w - sx;
	if ( sy + h > (int)src->h )
		h = src->h - sy;
}

void lbmpRect( LBitmap *bmp, int dx, int dy, int w, int h, u8 color )
{
	lbmpRectFill( bmp, dx, dy, w, 1, color );
	lbmpRectFill( bmp, dx, dy, 1, h, color );
	lbmpRectFill( bmp, dx, dy+h-1, w, 1, color );
	lbmpRectFill( bmp, dx+w-1, dy, 1, h, color );
}

void lbmpRectFill( LBitmap *bmp, int dx, int dy, int w, int h, u8 color )
{
	int sx=dx, sy=dy;
	LBitmap tmp;
	tmp.w = bmp->w;
	tmp.h = bmp->h;
	lbmpClip( bmp, &tmp, dx, dy, sx, sy, w, h );

	if ( w <= 0 || h <= 0 )
		return;

	u8 *pdst = &bmp->pixels[dy*bmp->w+dx];
	while( h-- )
	{
		u8 *b = pdst;
		int n = w;
		while( n-- )
			*b++ = color;

		pdst += bmp->w;
	}
}

void lbmpBlit( LBitmap *dest, LBitmap *src, int dx, int dy, int sx, int sy, int w, int h )
{
	lbmpClip( dest, src, dx, dy, sx, sy, w, h );

	if ( w <= 0 || h <= 0 )
		return;

	u8 *psrc = &src->pixels[sy*src->w+sx];
	u8 *pdst = &dest->pixels[dy*dest->w+dx];
	while( h-- )
	{
		u8 *a = psrc, *b = pdst;
		int n = w;
		while( n-- )
			*b++ = *a++;

		psrc += src->w;
		pdst += dest->w;
	}
}

void lbmpBlitMasked( LBitmap *dest, LBitmap *src, int dx, int dy, int sx, int sy, int w, int h )
{
	lbmpClip( dest, src, dx, dy, sx, sy, w, h );

	if ( w <= 0 || h <= 0 )
		return;

	u8 *psrc = &src->pixels[sy*src->w+sx];
	u8 *pdst = &dest->pixels[dy*dest->w+dx];
	while( h-- )
	{
		u8 *a = psrc, *b = pdst;
		int n = w;
		while( n-- )
		{
			u8 c = *a++;
			if ( c )
				*b++ = c;
			else
				b++;
		}

		psrc += src->w;
		pdst += dest->w;
	}
}

void lbmpBlitReplace( LBitmap *dest, LBitmap *src, int dx, int dy, int sx, int sy, int w, int h, u8 color )
{
	lbmpClip( dest, src, dx, dy, sx, sy, w, h );

	if ( w <= 0 || h <= 0 )
		return;

	u8 *psrc = &src->pixels[sy*src->w+sx];
	u8 *pdst = &dest->pixels[dy*dest->w+dx];
	while( h-- )
	{
		u8 *a = psrc, *b = pdst;
		int n = w;
		while( n-- )
		{
			u8 c = *a++;
			if ( c )
				*b++ = color;
			else
				b++;
		}

		psrc += src->w;
		pdst += dest->w;
	}
}
