struct Vertex
{
	float3 pos : POSITION;
	float2 uv : TEXCOORD0;
};

struct Interp
{
	float4 hPos : POSITION;
	float2 uv : TEXCOORD0;
};

#define PIXEL_SCALE_X	3.0f
#define PIXEL_SCALE_Y	3.6f
#define LOW_WIDTH	320
#define LOW_HEIGHT	200
#define LOW_SIZE	float2( LOW_WIDTH, LOW_HEIGHT )
#define HI_WIDTH	(LOW_WIDTH*PIXEL_SCALE_X)
#define HI_HEIGHT	(LOW_HEIGHT*PIXEL_SCALE_Y)
#define HI_SIZE		float2( HI_WIDTH, HI_HEIGHT )

sampler2D image;

void vs_main( Vertex vtx, out Interp interp )
{
	interp.hPos = float4( vtx.pos.xy + float2( -0.5f / HI_WIDTH, 0.5f / HI_HEIGHT ), vtx.pos.z, 1 );
	interp.uv = vtx.uv;
}

float4 ps_main( Interp interp ) : COLOR
{
	float2 uv = interp.uv;
	float hspread = 0.3f;
	float vspread = 0.2f;

	float4 a = tex2D( image, uv + float2(-hspread,-vspread)/LOW_SIZE );
	float4 b = tex2D( image, uv + float2( 0.0f,-vspread)/LOW_SIZE );
	float4 c = tex2D( image, uv + float2( hspread,-vspread)/LOW_SIZE );
	float4 d = tex2D( image, uv + float2(-hspread,vspread)/LOW_SIZE );
	float4 e = tex2D( image, uv + float2( 0.0f,vspread)/LOW_SIZE );
	float4 f = tex2D( image, uv + float2( hspread,vspread)/LOW_SIZE );

	float4 color = ( a + b + c + d + e + f ) / 6;

	float y = uv.y * HI_HEIGHT;
	float cycle = frac( y / 2 );
	
	color = abs( color );

	float t = saturate( color.g );
	float3 tint = lerp( float3( 0.0f, -0.1f, -0.2f ), float3( 0.1f, 0.2f, 0.3f ), t );
	color.rgb += tint;
	color = lerp( color, color.gggg, 0.4f );

	if ( cycle >= 0.5f )
		color -= float4( 0.5f, 0.5f, 0.5f, 0.5f );

	color *= 1.3f;

	return color;
}
